/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.entity;

import cofh.core.entity.NetServerHandlerFake;
import cofh.lib.util.helpers.ItemHelper;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;

public class CoFHFakePlayer
extends FakePlayer {
    private static GameProfile NAME = new GameProfile(UUID.fromString("5ae51d0b-e8bc-5a02-09f4-b5dbb05963da"), "[CoFH]");
    public boolean isSneaking = false;
    public ItemStack previousItem = null;
    public String myName = "[CoFH]";

    public CoFHFakePlayer(WorldServer worldServer) {
        super(worldServer, NAME);
        this.playerNetServerHandler = new NetServerHandlerFake(FMLCommonHandler.instance().getMinecraftServerInstance(), (EntityPlayerMP)this);
        this.addedToChunk = false;
    }

    public static boolean isBlockBreakable(CoFHFakePlayer coFHFakePlayer, World world, int n, int n2, int n3) {
        Block block = world.getBlock(n, n2, n3);
        if (block.isAir((IBlockAccess)world, n, n2, n3)) {
            return false;
        }
        if (coFHFakePlayer == null) {
            return block.getBlockHardness(world, n, n2, n3) > -1.0f;
        }
        return block.getPlayerRelativeBlockHardness((EntityPlayer)coFHFakePlayer, world, n, n2, n3) > -1.0f;
    }

    public void setItemInHand(ItemStack itemStack) {
        this.inventory.currentItem = 0;
        this.inventory.setInventorySlotContents(0, itemStack);
    }

    public void setItemInHand(int n) {
        this.inventory.currentItem = n;
    }

    public double getDistanceSq(double d, double d2, double d3) {
        return 0.0;
    }

    public double getDistance(double d, double d2, double d3) {
        return 0.0;
    }

    public boolean isSneaking() {
        return this.isSneaking;
    }

    public void onUpdate() {
        ItemStack itemStack = this.previousItem;
        ItemStack itemStack2 = this.getHeldItem();
        if (!ItemStack.areItemStacksEqual((ItemStack)itemStack2, (ItemStack)itemStack)) {
            if (itemStack != null) {
                this.getAttributeMap().removeAttributeModifiers(itemStack.getAttributeModifiers());
            }
            if (itemStack2 != null) {
                this.getAttributeMap().applyAttributeModifiers(itemStack2.getAttributeModifiers());
            }
            this.myName = "[CoFH]" + (itemStack2 != null ? " using " + itemStack2.getDisplayName() : "");
        }
        this.previousItem = itemStack2 == null ? null : itemStack2.copy();
        this.theItemInWorldManager.updateBlockRemoving();
        if (this.itemInUse != null) {
            // empty if block
        }
    }

    public void tickItemInUse(ItemStack itemStack) {
        if (itemStack != null && ItemHelper.itemsEqualWithMetadata(this.previousItem, this.itemInUse)) {
            this.itemInUseCount = ForgeEventFactory.onItemUseTick((EntityPlayer)this, (ItemStack)this.itemInUse, (int)this.itemInUseCount);
            if (this.itemInUseCount <= 0) {
                this.onItemUseFinish();
            } else {
                this.itemInUse.getItem().onUsingTick(this.itemInUse, (EntityPlayer)this, this.itemInUseCount);
                if (this.itemInUseCount <= 25 && this.itemInUseCount % 4 == 0) {
                    this.updateItemUse(itemStack, 5);
                }
                if (--this.itemInUseCount == 0 && !this.worldObj.isRemote) {
                    this.onItemUseFinish();
                }
            }
        } else {
            this.clearItemInUse();
        }
    }

    protected void updateItemUse(ItemStack itemStack, int n) {
        if (itemStack.getItemUseAction() == EnumAction.drink) {
            this.playSound("random.drink", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
        }
        if (itemStack.getItemUseAction() == EnumAction.eat) {
            this.playSound("random.eat", 0.5f + 0.5f * (float)this.rand.nextInt(2), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public String getDisplayName() {
        return this.getCommandSenderName();
    }

    public float getEyeHeight() {
        return 1.1f;
    }

    public ItemStack getCurrentArmor(int n) {
        return new ItemStack((Item)Items.diamond_chestplate);
    }

    public void addChatMessage(IChatComponent iChatComponent) {
    }

    public void addChatComponentMessage(IChatComponent iChatComponent) {
    }
}

